<?php
/**
 * Klasa Event
 * 
 * Przy użyciu tej klasy można rejestrować funkcje zwrotne, które będą 
 * wywoływane w kolejności rejestracji dla danego zdarzenia.
 */
class Event {
  /**
   * @var array Wielowymiarowa tablica zdarzenia => funkcje zwrotne
   */
  static protected $callbacks = array();
  
  /**
   * Rejestracja funkcji zwrotnej
   * 
   * @param string $eventName Nazwa zdarzenia będącego wyzwalaczem
   * @param mixed $callback Egzemplarz klasy Event_Callback czyli zamknięcia
   */
  static public function registerCallback($eventName, $callback)
  {
    if (!is_callable($callback)) {
      throw new Exception("Niepoprawna funkcja zwrotna!");
    }
    
    $eventName = strtolower($eventName);
    
    self::$callbacks[$eventName][] = $callback;
  }
  
  /**
   * Wyzwolenie zdarzenia
   * 
   * @param string $eventName Nazwa zdarzenia, które ma być wyzwolone
   * @param mixed $data Dane, które zostaną wysłane do funkcji zwrotnej
   */
  static public function trigger($eventName, $data)
  {
    $eventName = strtolower($eventName);
    
    if (isset(self::$callbacks[$eventName])) {
      foreach (self::$callbacks[$eventName] as $callback) {
        // Funkcja zwrotna jest albo zamknięciem albo obiektem zawierającym definicję metody __invoke()
        $callback($data);
      }
    }
  }
}
?>